﻿using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Update
{
    /// <summary>
    /// Connect to CRM step.
    /// </summary>
    public class ConnectToCrmStep : FilterBase<VideoVisitUpdateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitUpdateStateObject state)
        {
            state.OrganizationServiceProxy = PipelineUtilities.ConnectToCrm(state.OrganizationName, PipelineUtilities.CrmAuthenticationMode.Ad);          
        }
    }
}